<?php

if ( ! function_exists( 'synergia_select_map_general_meta' ) ) {
	function synergia_select_map_general_meta() {
		
		$general_meta_box = synergia_select_create_meta_box(
			array(
				'scope' => apply_filters( 'synergia_select_set_scope_for_meta_boxes', array( 'page', 'post' ), 'general_meta' ),
				'title' => esc_html__( 'General', 'synergia' ),
				'name'  => 'general_meta'
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		synergia_select_create_meta_box_field(
			array(
				'name'        => 'qodef_page_slider_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Slider Shortcode', 'synergia' ),
				'description' => esc_html__( 'Paste your slider shortcode here', 'synergia' ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		/***************** Content Layout - begin **********************/
		
		synergia_select_create_meta_box_field(
			array(
				'name'          => 'qodef_page_content_behind_header_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Always put content behind header', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will put page content behind page header', 'synergia' ),
				'parent'        => $general_meta_box
			)
		);
		
		$qodef_content_padding_group = synergia_select_add_admin_group(
			array(
				'name'        => 'content_padding_group',
				'title'       => esc_html__( 'Content Style', 'synergia' ),
				'description' => esc_html__( 'Define styles for Content area', 'synergia' ),
				'parent'      => $general_meta_box
			)
		);
		
			$qodef_content_padding_row = synergia_select_add_admin_row(
				array(
					'name'   => 'qodef_content_padding_row',
					'next'   => true,
					'parent' => $qodef_content_padding_group
				)
			);
		
				synergia_select_create_meta_box_field(
					array(
						'name'   => 'qodef_page_content_top_padding',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Content Top Padding', 'synergia' ),
						'parent' => $qodef_content_padding_row,
						'args'   => array(
							'suffix' => 'px'
						)
					)
				);
				
				synergia_select_create_meta_box_field(
					array(
						'name'    => 'qodef_page_content_top_padding_mobile',
						'type'    => 'selectsimple',
						'label'   => esc_html__( 'Set this top padding for mobile header', 'synergia' ),
						'parent'  => $qodef_content_padding_row,
						'options' => synergia_select_get_yes_no_select_array( false )
					)
				);
		
		synergia_select_create_meta_box_field(
			array(
				'name'        => 'qodef_page_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Page Background Color', 'synergia' ),
				'description' => esc_html__( 'Choose background color for page content', 'synergia' ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Content Layout - end **********************/
		
		/***************** Boxed Layout - begin **********************/
		
		synergia_select_create_meta_box_field(
			array(
				'name'    => 'qodef_boxed_meta',
				'type'    => 'select',
				'label'   => esc_html__( 'Boxed Layout', 'synergia' ),
				'parent'  => $general_meta_box,
				'options' => synergia_select_get_yes_no_select_array(),
				'args'    => array(
					'dependence' => true,
					'hide'       => array(
						''    => '#qodef_boxed_container_meta',
						'no'  => '#qodef_boxed_container_meta',
						'yes' => ''
					),
					'show'       => array(
						''    => '',
						'no'  => '',
						'yes' => '#qodef_boxed_container_meta'
					)
				)
			)
		);
		
			$boxed_container_meta = synergia_select_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'boxed_container_meta',
					'hidden_property' => 'qodef_boxed_meta',
					'hidden_values'   => array(
						'',
						'no'
					)
				)
			);
		
				synergia_select_create_meta_box_field(
					array(
						'name'        => 'qodef_page_background_color_in_box_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Page Background Color', 'synergia' ),
						'description' => esc_html__( 'Choose the page background color outside box', 'synergia' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				synergia_select_create_meta_box_field(
					array(
						'name'        => 'qodef_boxed_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'synergia' ),
						'description' => esc_html__( 'Choose an image to be displayed in background', 'synergia' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				synergia_select_create_meta_box_field(
					array(
						'name'        => 'qodef_boxed_pattern_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Pattern', 'synergia' ),
						'description' => esc_html__( 'Choose an image to be used as background pattern', 'synergia' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				synergia_select_create_meta_box_field(
					array(
						'name'          => 'qodef_boxed_background_image_attachment_meta',
						'type'          => 'select',
						'default_value' => 'fixed',
						'label'         => esc_html__( 'Background Image Attachment', 'synergia' ),
						'description'   => esc_html__( 'Choose background image attachment', 'synergia' ),
						'parent'        => $boxed_container_meta,
						'options'       => array(
							''       => esc_html__( 'Default', 'synergia' ),
							'fixed'  => esc_html__( 'Fixed', 'synergia' ),
							'scroll' => esc_html__( 'Scroll', 'synergia' )
						)
					)
				);
		
		/***************** Boxed Layout - end **********************/
		
		/***************** Passepartout Layout - begin **********************/
		
		synergia_select_create_meta_box_field(
			array(
				'name'          => 'qodef_paspartu_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Passepartout', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will display passepartout around site content', 'synergia' ),
				'parent'        => $general_meta_box,
				'options'       => synergia_select_get_yes_no_select_array(),
				'args'    => array(
					'dependence'    => true,
					'hide'          => array(
						''    => '#qodef_qodef_paspartu_container_meta',
						'no'  => '#qodef_qodef_paspartu_container_meta',
						'yes' => ''
					),
					'show'          => array(
						''    => '',
						'no'  => '',
						'yes' => '#qodef_qodef_paspartu_container_meta'
					)
				)
			)
		);
		
			$paspartu_container_meta = synergia_select_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'qodef_paspartu_container_meta',
					'hidden_property' => 'qodef_paspartu_meta',
					'hidden_values'   => array(
						'',
						'no'
					)
				)
			);
		
				synergia_select_create_meta_box_field(
					array(
						'name'        => 'qodef_paspartu_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Passepartout Color', 'synergia' ),
						'description' => esc_html__( 'Choose passepartout color, default value is #ffffff', 'synergia' ),
						'parent'      => $paspartu_container_meta
					)
				);
				
				synergia_select_create_meta_box_field(
					array(
						'name'        => 'qodef_paspartu_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Passepartout Size', 'synergia' ),
						'description' => esc_html__( 'Enter size amount for passepartout', 'synergia' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
		
				synergia_select_create_meta_box_field(
					array(
						'name'        => 'qodef_paspartu_responsive_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Responsive Passepartout Size', 'synergia' ),
						'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (tablets and mobiles view)', 'synergia' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
				
				synergia_select_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'qodef_disable_top_paspartu_meta',
						'label'         => esc_html__( 'Disable Top Passepartout', 'synergia' ),
						'options'       => synergia_select_get_yes_no_select_array(),
					)
				);
		
		/***************** Passepartout Layout - end **********************/
		
		/***************** Content Width Layout - begin **********************/
		
		synergia_select_create_meta_box_field(
			array(
				'name'          => 'qodef_initial_content_width_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Initial Width of Content', 'synergia' ),
				'description'   => esc_html__( 'Choose the initial width of content which is in grid (Applies to pages set to "Default Template" and rows set to "In Grid")', 'synergia' ),
				'parent'        => $general_meta_box,
				'options'       => array(
					''                => esc_html__( 'Default', 'synergia' ),
					'qodef-grid-1100' => esc_html__( '1100px', 'synergia' ),
					'qodef-grid-1300' => esc_html__( '1300px', 'synergia' ),
					'qodef-grid-1200' => esc_html__( '1200px', 'synergia' ),
					'qodef-grid-1000' => esc_html__( '1000px', 'synergia' ),
					'qodef-grid-800'  => esc_html__( '800px', 'synergia' )
				)
			)
		);
		
		/***************** Content Width Layout - end **********************/
		
		/***************** Smooth Page Transitions Layout - begin **********************/
		
		synergia_select_create_meta_box_field(
			array(
				'name'          => 'qodef_smooth_page_transitions_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Smooth Page Transitions', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will perform a smooth transition between pages when clicking on links', 'synergia' ),
				'parent'        => $general_meta_box,
				'options'       => synergia_select_get_yes_no_select_array(),
				'args'          => array(
					'dependence' => true,
					'hide'       => array(
						''    => '#qodef_page_transitions_container_meta',
						'no'  => '#qodef_page_transitions_container_meta',
						'yes' => ''
					),
					'show'       => array(
						''    => '',
						'no'  => '',
						'yes' => '#qodef_page_transitions_container_meta'
					)
				)
			)
		);
		
			$page_transitions_container_meta = synergia_select_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'page_transitions_container_meta',
					'hidden_property' => 'qodef_smooth_page_transitions_meta',
					'hidden_values'   => array(
						'',
						'no'
					)
				)
			);
		
				synergia_select_create_meta_box_field(
					array(
						'name'        => 'qodef_page_transition_preloader_meta',
						'type'        => 'select',
						'label'       => esc_html__( 'Enable Preloading Animation', 'synergia' ),
						'description' => esc_html__( 'Enabling this option will display an animated preloader while the page content is loading', 'synergia' ),
						'parent'      => $page_transitions_container_meta,
						'options'     => synergia_select_get_yes_no_select_array(),
						'args'        => array(
							'dependence' => true,
							'hide'       => array(
								''    => '#qodef_page_transition_preloader_container_meta',
								'no'  => '#qodef_page_transition_preloader_container_meta',
								'yes' => ''
							),
							'show'       => array(
								''    => '',
								'no'  => '',
								'yes' => '#qodef_page_transition_preloader_container_meta'
							)
						)
					)
				);
				
				$page_transition_preloader_container_meta = synergia_select_add_admin_container(
					array(
						'parent'          => $page_transitions_container_meta,
						'name'            => 'page_transition_preloader_container_meta',
						'hidden_property' => 'qodef_page_transition_preloader_meta',
						'hidden_values'   => array(
							'',
							'no'
						)
					)
				);
				
					synergia_select_create_meta_box_field(
						array(
							'name'   => 'qodef_smooth_pt_bgnd_color_meta',
							'type'   => 'color',
							'label'  => esc_html__( 'Page Loader Background Color', 'synergia' ),
							'parent' => $page_transition_preloader_container_meta
						)
					);
					
					$group_pt_spinner_animation_meta = synergia_select_add_admin_group(
						array(
							'name'        => 'group_pt_spinner_animation_meta',
							'title'       => esc_html__( 'Loader Style', 'synergia' ),
							'description' => esc_html__( 'Define styles for loader spinner animation', 'synergia' ),
							'parent'      => $page_transition_preloader_container_meta
						)
					);
					
					$row_pt_spinner_animation_meta = synergia_select_add_admin_row(
						array(
							'name'   => 'row_pt_spinner_animation_meta',
							'parent' => $group_pt_spinner_animation_meta
						)
					);
					
					synergia_select_create_meta_box_field(
						array(
							'type'    => 'selectsimple',
							'name'    => 'qodef_smooth_pt_spinner_type_meta',
							'label'   => esc_html__( 'Spinner Type', 'synergia' ),
							'parent'  => $row_pt_spinner_animation_meta,
							'options' => array(
								''                      => esc_html__( 'Default', 'synergia' ),
								'synergia'        		=> esc_html__( 'Synergia', 'synergia' ),
								'rotate_circles'        => esc_html__( 'Rotate Circles', 'synergia' ),
								'pulse'                 => esc_html__( 'Pulse', 'synergia' ),
								'double_pulse'          => esc_html__( 'Double Pulse', 'synergia' ),
								'cube'                  => esc_html__( 'Cube', 'synergia' ),
								'rotating_cubes'        => esc_html__( 'Rotating Cubes', 'synergia' ),
								'stripes'               => esc_html__( 'Stripes', 'synergia' ),
								'wave'                  => esc_html__( 'Wave', 'synergia' ),
								'two_rotating_circles'  => esc_html__( '2 Rotating Circles', 'synergia' ),
								'five_rotating_circles' => esc_html__( '5 Rotating Circles', 'synergia' ),
								'atom'                  => esc_html__( 'Atom', 'synergia' ),
								'clock'                 => esc_html__( 'Clock', 'synergia' ),
								'mitosis'               => esc_html__( 'Mitosis', 'synergia' ),
								'lines'                 => esc_html__( 'Lines', 'synergia' ),
								'fussion'               => esc_html__( 'Fussion', 'synergia' ),
								'wave_circles'          => esc_html__( 'Wave Circles', 'synergia' ),
								'pulse_circles'         => esc_html__( 'Pulse Circles', 'synergia' )
							)
						)
					);
					
					synergia_select_create_meta_box_field(
						array(
							'type'   => 'colorsimple',
							'name'   => 'qodef_smooth_pt_spinner_color_meta',
							'label'  => esc_html__( 'Spinner Color', 'synergia' ),
							'parent' => $row_pt_spinner_animation_meta
						)
					);
					
					synergia_select_create_meta_box_field(
						array(
							'name'        => 'qodef_page_transition_fadeout_meta',
							'type'        => 'select',
							'label'       => esc_html__( 'Enable Fade Out Animation', 'synergia' ),
							'description' => esc_html__( 'Enabling this option will turn on fade out animation when leaving page', 'synergia' ),
							'options'     => synergia_select_get_yes_no_select_array(),
							'parent'      => $page_transitions_container_meta
						
						)
					);
		
		/***************** Smooth Page Transitions Layout - end **********************/
		
		/***************** Comments Layout - begin **********************/
		
		synergia_select_create_meta_box_field(
			array(
				'name'        => 'qodef_page_comments_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Show Comments', 'synergia' ),
				'description' => esc_html__( 'Enabling this option will show comments on your page', 'synergia' ),
				'parent'      => $general_meta_box,
				'options'     => synergia_select_get_yes_no_select_array()
			)
		);
		
		/***************** Comments Layout - end **********************/
	}
	
	add_action( 'synergia_select_meta_boxes_map', 'synergia_select_map_general_meta', 10 );
}