<?php

if ( ! function_exists( 'synergia_select_map_post_audio_meta' ) ) {
	function synergia_select_map_post_audio_meta() {
		$audio_post_format_meta_box = synergia_select_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Audio Post Format', 'synergia' ),
				'name'  => 'post_format_audio_meta'
			)
		);
		
		synergia_select_create_meta_box_field(
			array(
				'name'          => 'qodef_audio_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Audio Type', 'synergia' ),
				'description'   => esc_html__( 'Choose audio type', 'synergia' ),
				'parent'        => $audio_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Audio Service', 'synergia' ),
					'self'            => esc_html__( 'Self Hosted', 'synergia' )
				),
				'args'          => array(
					'dependence' => true,
					'hide'       => array(
						'social_networks' => '#qodef_qodef_audio_self_hosted_container',
						'self'            => '#qodef_qodef_audio_embedded_container'
					),
					'show'       => array(
						'social_networks' => '#qodef_qodef_audio_embedded_container',
						'self'            => '#qodef_qodef_audio_self_hosted_container'
					)
				)
			)
		);
		
		$qodef_audio_embedded_container = synergia_select_add_admin_container(
			array(
				'parent'          => $audio_post_format_meta_box,
				'name'            => 'qodef_audio_embedded_container',
				'hidden_property' => 'qodef_audio_type_meta',
				'hidden_value'    => 'self'
			)
		);
		
		$qodef_audio_self_hosted_container = synergia_select_add_admin_container(
			array(
				'parent'          => $audio_post_format_meta_box,
				'name'            => 'qodef_audio_self_hosted_container',
				'hidden_property' => 'qodef_audio_type_meta',
				'hidden_value'    => 'social_networks'
			)
		);
		
		synergia_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_audio_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio URL', 'synergia' ),
				'description' => esc_html__( 'Enter audio URL', 'synergia' ),
				'parent'      => $qodef_audio_embedded_container,
			)
		);
		
		synergia_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_audio_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio Link', 'synergia' ),
				'description' => esc_html__( 'Enter audio link', 'synergia' ),
				'parent'      => $qodef_audio_self_hosted_container,
			)
		);
	}
	
	add_action( 'synergia_select_meta_boxes_map', 'synergia_select_map_post_audio_meta', 23 );
}