<?php

if ( ! function_exists( 'synergia_select_map_post_video_meta' ) ) {
	function synergia_select_map_post_video_meta() {
		$video_post_format_meta_box = synergia_select_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Video Post Format', 'synergia' ),
				'name'  => 'post_format_video_meta'
			)
		);
		
		synergia_select_create_meta_box_field(
			array(
				'name'          => 'qodef_video_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Video Type', 'synergia' ),
				'description'   => esc_html__( 'Choose video type', 'synergia' ),
				'parent'        => $video_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Video Service', 'synergia' ),
					'self'            => esc_html__( 'Self Hosted', 'synergia' )
				),
				'args'          => array(
					'dependence' => true,
					'hide'       => array(
						'social_networks' => '#qodef_qodef_video_self_hosted_container',
						'self'            => '#qodef_qodef_video_embedded_container'
					),
					'show'       => array(
						'social_networks' => '#qodef_qodef_video_embedded_container',
						'self'            => '#qodef_qodef_video_self_hosted_container'
					)
				)
			)
		);
		
		$qodef_video_embedded_container = synergia_select_add_admin_container(
			array(
				'parent'          => $video_post_format_meta_box,
				'name'            => 'qodef_video_embedded_container',
				'hidden_property' => 'qodef_video_type_meta',
				'hidden_value'    => 'self'
			)
		);
		
		$qodef_video_self_hosted_container = synergia_select_add_admin_container(
			array(
				'parent'          => $video_post_format_meta_box,
				'name'            => 'qodef_video_self_hosted_container',
				'hidden_property' => 'qodef_video_type_meta',
				'hidden_value'    => 'social_networks'
			)
		);
		
		synergia_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_video_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video URL', 'synergia' ),
				'description' => esc_html__( 'Enter Video URL', 'synergia' ),
				'parent'      => $qodef_video_embedded_container,
			)
		);
		
		synergia_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_video_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video MP4', 'synergia' ),
				'description' => esc_html__( 'Enter video URL for MP4 format', 'synergia' ),
				'parent'      => $qodef_video_self_hosted_container,
			)
		);
		
		synergia_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Video Image', 'synergia' ),
				'description' => esc_html__( 'Enter video image', 'synergia' ),
				'parent'      => $qodef_video_self_hosted_container,
			)
		);
	}
	
	add_action( 'synergia_select_meta_boxes_map', 'synergia_select_map_post_video_meta', 22 );
}