<?php

if ( ! function_exists( 'synergia_select_get_blog_list_types_options' ) ) {
	function synergia_select_get_blog_list_types_options() {
		$blog_list_type_options = apply_filters( 'synergia_select_blog_list_type_global_option', $blog_list_type_options = array() );
		
		return $blog_list_type_options;
	}
}

if ( ! function_exists( 'synergia_select_blog_options_map' ) ) {
	function synergia_select_blog_options_map() {
		$blog_list_type_options = synergia_select_get_blog_list_types_options();
		
		synergia_select_add_admin_page(
			array(
				'slug'  => '_blog_page',
				'title' => esc_html__( 'Blog', 'synergia' ),
				'icon'  => 'fa fa-files-o'
			)
		);
		
		/**
		 * Blog Lists
		 */
		$panel_blog_lists = synergia_select_add_admin_panel(
			array(
				'page'  => '_blog_page',
				'name'  => 'panel_blog_lists',
				'title' => esc_html__( 'Blog Lists', 'synergia' )
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'blog_list_type',
				'type'          => 'select',
				'label'         => esc_html__( 'Blog Layout for Archive Pages', 'synergia' ),
				'description'   => esc_html__( 'Choose a default blog layout for archived blog post lists', 'synergia' ),
				'default_value' => 'standard',
				'parent'        => $panel_blog_lists,
				'options'       => $blog_list_type_options
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'archive_sidebar_layout',
				'type'          => 'select',
				'label'         => esc_html__( 'Sidebar Layout for Archive Pages', 'synergia' ),
				'description'   => esc_html__( 'Choose a sidebar layout for archived blog post lists', 'synergia' ),
				'default_value' => '',
				'parent'        => $panel_blog_lists,
                'options'       => synergia_select_get_custom_sidebars_options(),
			)
		);
		
		$synergia_custom_sidebars = synergia_select_get_custom_sidebars();
		if ( count( $synergia_custom_sidebars ) > 0 ) {
			synergia_select_add_admin_field(
				array(
					'name'        => 'archive_custom_sidebar_area',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Sidebar to Display for Archive Pages', 'synergia' ),
					'description' => esc_html__( 'Choose a sidebar to display on archived blog post lists. Default sidebar is "Sidebar Page"', 'synergia' ),
					'parent'      => $panel_blog_lists,
					'options'     => synergia_select_get_custom_sidebars(),
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'blog_masonry_layout',
				'type'          => 'select',
				'label'         => esc_html__( 'Masonry - Layout', 'synergia' ),
				'default_value' => 'in-grid',
				'description'   => esc_html__( 'Set masonry layout. Default is in grid.', 'synergia' ),
				'parent'        => $panel_blog_lists,
				'options'       => array(
					'in-grid'    => esc_html__( 'In Grid', 'synergia' ),
					'full-width' => esc_html__( 'Full Width', 'synergia' )
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'blog_masonry_number_of_columns',
				'type'          => 'select',
				'label'         => esc_html__( 'Masonry - Number of Columns', 'synergia' ),
				'default_value' => 'three',
				'description'   => esc_html__( 'Set number of columns for your masonry blog lists. Default value is 4 columns', 'synergia' ),
				'parent'        => $panel_blog_lists,
				'options'       => array(
					'two'   => esc_html__( '2 Columns', 'synergia' ),
					'three' => esc_html__( '3 Columns', 'synergia' ),
					'four'  => esc_html__( '4 Columns', 'synergia' ),
					'five'  => esc_html__( '5 Columns', 'synergia' )
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'blog_masonry_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Masonry - Space Between Items', 'synergia' ),
				'description'   => esc_html__( 'Set space size between posts for your masonry blog lists. Default value is normal', 'synergia' ),
				'default_value' => 'normal',
				'options'       => synergia_select_get_space_between_items_array(),
				'parent'        => $panel_blog_lists
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'blog_list_featured_image_proportion',
				'type'          => 'select',
				'label'         => esc_html__( 'Masonry - Featured Image Proportion', 'synergia' ),
				'default_value' => 'fixed',
				'description'   => esc_html__( 'Choose type of proportions you want to use for featured images on masonry blog lists', 'synergia' ),
				'parent'        => $panel_blog_lists,
				'options'       => array(
					'fixed'    => esc_html__( 'Fixed', 'synergia' ),
					'original' => esc_html__( 'Original', 'synergia' )
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'blog_pagination_type',
				'type'          => 'select',
				'label'         => esc_html__( 'Pagination Type', 'synergia' ),
				'description'   => esc_html__( 'Choose a pagination layout for Blog Lists', 'synergia' ),
				'parent'        => $panel_blog_lists,
				'default_value' => 'standard',
				'options'       => array(
					'standard'        => esc_html__( 'Standard', 'synergia' ),
					'load-more'       => esc_html__( 'Load More', 'synergia' ),
					'infinite-scroll' => esc_html__( 'Infinite Scroll', 'synergia' ),
					'no-pagination'   => esc_html__( 'No Pagination', 'synergia' )
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'text',
				'name'          => 'number_of_chars',
				'default_value' => '40',
				'label'         => esc_html__( 'Number of Words in Excerpt', 'synergia' ),
				'description'   => esc_html__( 'Enter a number of words in excerpt (article summary). Default value is 40', 'synergia' ),
				'parent'        => $panel_blog_lists,
				'args'          => array(
					'col_width' => 3
				)
			)
		);

		synergia_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'enable_blog_tags',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Blog Tags', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will show tags on blog', 'synergia' ),
				'parent'        => $panel_blog_lists,
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		/**
		 * Blog Single
		 */
		$panel_blog_single = synergia_select_add_admin_panel(
			array(
				'page'  => '_blog_page',
				'name'  => 'panel_blog_single',
				'title' => esc_html__( 'Blog Single', 'synergia' )
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'blog_single_sidebar_layout',
				'type'          => 'select',
				'label'         => esc_html__( 'Sidebar Layout', 'synergia' ),
				'description'   => esc_html__( 'Choose a sidebar layout for Blog Single pages', 'synergia' ),
				'default_value' => '',
				'parent'        => $panel_blog_single,
                'options'       => synergia_select_get_custom_sidebars_options()
			)
		);
		
		if ( count( $synergia_custom_sidebars ) > 0 ) {
			synergia_select_add_admin_field(
				array(
					'name'        => 'blog_single_custom_sidebar_area',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Sidebar to Display', 'synergia' ),
					'description' => esc_html__( 'Choose a sidebar to display on Blog Single pages. Default sidebar is "Sidebar"', 'synergia' ),
					'parent'      => $panel_blog_single,
					'options'     => synergia_select_get_custom_sidebars(),
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'show_title_area_blog',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will show title area on single post pages', 'synergia' ),
				'parent'        => $panel_blog_single,
				'options'       => synergia_select_get_yes_no_select_array(),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'blog_single_title_in_title_area',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Show Post Title in Title Area', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will show post title in title area on single post pages', 'synergia' ),
				'parent'        => $panel_blog_single,
				'default_value' => 'no'
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'blog_single_related_posts',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Show Related Posts', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will show related posts on single post pages', 'synergia' ),
				'parent'        => $panel_blog_single,
				'default_value' => 'yes'
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'blog_single_comments',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Show Comments Form', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will show comments form on single post pages', 'synergia' ),
				'parent'        => $panel_blog_single,
				'default_value' => 'yes'
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'blog_single_navigation',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Prev/Next Single Post Navigation Links', 'synergia' ),
				'description'   => esc_html__( 'Enable navigation links through the blog posts (left and right arrows will appear)', 'synergia' ),
				'parent'        => $panel_blog_single,
				'args'          => array(
					'dependence'             => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#qodef_qodef_blog_single_navigation_container'
				)
			)
		);
		
		$blog_single_navigation_container = synergia_select_add_admin_container(
			array(
				'name'            => 'qodef_blog_single_navigation_container',
				'hidden_property' => 'blog_single_navigation',
				'hidden_value'    => 'no',
				'parent'          => $panel_blog_single,
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'blog_navigation_through_same_category',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Navigation Only in Current Category', 'synergia' ),
				'description'   => esc_html__( 'Limit your navigation only through current category', 'synergia' ),
				'parent'        => $blog_single_navigation_container,
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'blog_author_info',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Author Info Box', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will display author name and descriptions on single post pages', 'synergia' ),
				'parent'        => $panel_blog_single,
				'args'          => array(
					'dependence'             => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#qodef_qodef_blog_single_author_info_container'
				)
			)
		);
		
		$blog_single_author_info_container = synergia_select_add_admin_container(
			array(
				'name'            => 'qodef_blog_single_author_info_container',
				'hidden_property' => 'blog_author_info',
				'hidden_value'    => 'no',
				'parent'          => $panel_blog_single,
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'blog_author_info_email',
				'default_value' => 'no',
				'label'         => esc_html__( 'Show Author Email', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will show author email', 'synergia' ),
				'parent'        => $blog_single_author_info_container,
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'blog_single_author_social',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Author Social Icons', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will show author social icons on single post pages', 'synergia' ),
				'parent'        => $blog_single_author_info_container,
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		do_action( 'synergia_select_blog_single_options_map', $panel_blog_single );
	}
	
	add_action( 'synergia_select_options_map', 'synergia_select_blog_options_map', 10 );
}