<?php

if ( ! function_exists( 'synergia_select_logo_options_map' ) ) {
	function synergia_select_logo_options_map() {
		
		synergia_select_add_admin_page(
			array(
				'slug'  => '_logo_page',
				'title' => esc_html__( 'Logo', 'synergia' ),
				'icon'  => 'fa fa-coffee'
			)
		);
		
		$panel_logo = synergia_select_add_admin_panel(
			array(
				'page'  => '_logo_page',
				'name'  => 'panel_logo',
				'title' => esc_html__( 'Logo', 'synergia' )
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'parent'        => $panel_logo,
				'type'          => 'yesno',
				'name'          => 'hide_logo',
				'default_value' => 'no',
				'label'         => esc_html__( 'Hide Logo', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will hide logo image', 'synergia' ),
				'args'          => array(
					"dependence"             => true,
					"dependence_hide_on_yes" => "#qodef_hide_logo_container",
					"dependence_show_on_yes" => ""
				)
			)
		);
		
		$hide_logo_container = synergia_select_add_admin_container(
			array(
				'parent'          => $panel_logo,
				'name'            => 'hide_logo_container',
				'hidden_property' => 'hide_logo',
				'hidden_value'    => 'yes'
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'logo_image',
				'type'          => 'image',
				'default_value' => SELECT_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Default', 'synergia' ),
				'parent'        => $hide_logo_container
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'logo_image_dark',
				'type'          => 'image',
				'default_value' => SELECT_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Dark', 'synergia' ),
				'parent'        => $hide_logo_container
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'logo_image_light',
				'type'          => 'image',
				'default_value' => SELECT_ASSETS_ROOT . "/img/logo_white.png",
				'label'         => esc_html__( 'Logo Image - Light', 'synergia' ),
				'parent'        => $hide_logo_container
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'logo_image_sticky',
				'type'          => 'image',
				'default_value' => SELECT_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Sticky', 'synergia' ),
				'parent'        => $hide_logo_container
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'name'          => 'logo_image_mobile',
				'type'          => 'image',
				'default_value' => SELECT_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Mobile', 'synergia' ),
				'parent'        => $hide_logo_container
			)
		);
	}
	
	add_action( 'synergia_select_options_map', 'synergia_select_logo_options_map', 2 );
}