<?php

if ( ! function_exists( 'synergia_select_register_header_minimal_type' ) ) {
	/**
	 * This function is used to register header type class for header factory file
	 */
	function synergia_select_register_header_minimal_type( $header_types ) {
		$header_type = array(
			'header-minimal' => 'Synergia\Modules\Header\Types\HeaderMinimal'
		);
		
		$header_types = array_merge( $header_types, $header_type );
		
		return $header_types;
	}
}

if ( ! function_exists( 'synergia_select_init_register_header_minimal_type' ) ) {
	/**
	 * This function is used to wait header-function.php file to init header object and then to init hook registration function above
	 */
	function synergia_select_init_register_header_minimal_type() {
		add_filter( 'synergia_select_register_header_type_class', 'synergia_select_register_header_minimal_type' );
	}
	
	add_action( 'synergia_select_before_header_function_init', 'synergia_select_init_register_header_minimal_type' );
}

if ( ! function_exists( 'synergia_select_include_header_minimal_full_screen_menu' ) ) {
	/**
	 * Registers additional menu navigation for theme
	 */
	function synergia_select_include_header_minimal_full_screen_menu( $menus ) {
		$menus['popup-navigation'] = esc_html__( 'Full Screen Navigation', 'synergia' );
		
		return $menus;
	}
	
	if ( synergia_select_check_is_header_type_enabled( 'header-minimal' ) ) {
		add_filter( 'synergia_select_register_headers_menu', 'synergia_select_include_header_minimal_full_screen_menu' );
	}
}

if ( ! function_exists( 'synergia_select_register_header_minimal_full_screen_menu_widgets' ) ) {
	/**
	 * Registers additional widget areas for this header type
	 */
	function synergia_select_register_header_minimal_full_screen_menu_widgets() {
		register_sidebar(
			array(
				'id'            => 'fullscreen_menu_above',
				'name'          => esc_html__( 'Fullscreen Menu Top', 'synergia' ),
				'description'   => esc_html__( 'This widget area is rendered above full screen menu', 'synergia' ),
				'before_widget' => '<div class="%2$s qodef-fullscreen-menu-above-widget">',
				'after_widget'  => '</div>',
				'before_title'  => '<h5 class="qodef-widget-title">',
				'after_title'   => '</h5>'
			)
		);
		
		register_sidebar(
			array(
				'id'            => 'fullscreen_menu_below',
				'name'          => esc_html__( 'Fullscreen Menu Bottom', 'synergia' ),
				'description'   => esc_html__( 'This widget area is rendered below full screen menu', 'synergia' ),
				'before_widget' => '<div class="%2$s qodef-fullscreen-menu-below-widget">',
				'after_widget'  => '</div>',
				'before_title'  => '<h5 class="qodef-widget-title">',
				'after_title'   => '</h5>'
			)
		);
	}
	
	if ( synergia_select_check_is_header_type_enabled( 'header-minimal' ) ) {
		add_action( 'widgets_init', 'synergia_select_register_header_minimal_full_screen_menu_widgets' );
	}
}