<?php

if ( ! function_exists( 'synergia_select_get_hide_dep_for_header_standard_options' ) ) {
	function synergia_select_get_hide_dep_for_header_standard_options() {
		$hide_dep_options = apply_filters( 'synergia_select_header_standard_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'synergia_select_header_standard_map' ) ) {
	function synergia_select_header_standard_map( $parent ) {
		$hide_dep_options = synergia_select_get_hide_dep_for_header_standard_options();
		
		synergia_select_add_admin_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'set_menu_area_position',
				'default_value'   => 'center',
				'label'           => esc_html__( 'Choose Menu Area Position', 'synergia' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'synergia' ),
				'options'         => array(
                    'center' => esc_html__( 'Center', 'synergia' ),
					'right'  => esc_html__( 'Right', 'synergia' ),
					'left'   => esc_html__( 'Left', 'synergia' )
				),
				'hidden_property' => 'header_type',
				'hidden_values'   => $hide_dep_options
			)
		);
	}
	
	add_action( 'synergia_select_additional_header_menu_area_options_map', 'synergia_select_header_standard_map' );
}