<?php

if ( ! function_exists( 'synergia_select_sticky_header_styles' ) ) {
	/**
	 * Generates styles for sticky haeder
	 */
	function synergia_select_sticky_header_styles() {
		$background_color        = synergia_select_options()->getOptionValue( 'sticky_header_background_color' );
		$background_transparency = synergia_select_options()->getOptionValue( 'sticky_header_transparency' );
		$border_color            = synergia_select_options()->getOptionValue( 'sticky_header_border_color' );
		$header_height           = synergia_select_options()->getOptionValue( 'sticky_header_height' );
		
		if ( ! empty( $background_color ) ) {
			$header_background_color              = $background_color;
			$header_background_color_transparency = 1;
			
			if ( $background_transparency !== '' ) {
				$header_background_color_transparency = $background_transparency;
			}
			
			echo synergia_select_dynamic_css( '.qodef-page-header .qodef-sticky-header .qodef-sticky-holder', array( 'background-color' => synergia_select_rgba_color( $header_background_color, $header_background_color_transparency ) ) );
		}
		
		if ( ! empty( $border_color ) ) {
			echo synergia_select_dynamic_css( '.qodef-page-header .qodef-sticky-header .qodef-sticky-holder', array( 'border-color' => $border_color ) );
			echo synergia_select_dynamic_css( '.qodef-page-header .qodef-sticky-header .qodef-sticky-holder', array( 'border-style' => 'solid' ) );
			echo synergia_select_dynamic_css( '.qodef-page-header .qodef-sticky-header .qodef-sticky-holder', array( 'box-shadow' => 'none' ) );
		}
		
		if ( ! empty( $header_height ) ) {
			$height = synergia_select_filter_px( $header_height ) . 'px';
			
			echo synergia_select_dynamic_css( '.qodef-page-header .qodef-sticky-header', array( 'height' => $height ) );
			echo synergia_select_dynamic_css( '.qodef-page-header .qodef-sticky-header .qodef-logo-wrapper a', array( 'max-height' => $height ) );
		}
		
		// sticky menu style
		
		$menu_item_styles = synergia_select_get_typography_styles( 'sticky' );
		
		$menu_item_selector = array(
			'.qodef-main-menu.qodef-sticky-nav > ul > li > a'
		);
		
		echo synergia_select_dynamic_css( $menu_item_selector, $menu_item_styles );
		
		
		$hover_color = synergia_select_options()->getOptionValue( 'sticky_hovercolor' );
		
		$menu_item_hover_styles = array();
		if ( ! empty( $hover_color ) ) {
			$menu_item_hover_styles['color'] = $hover_color;
		}
		
		$menu_item_hover_selector = array(
			'.qodef-main-menu.qodef-sticky-nav > ul > li:hover > a',
			'.qodef-main-menu.qodef-sticky-nav > ul > li.qodef-active-item > a'
		);
		
		echo synergia_select_dynamic_css( $menu_item_hover_selector, $menu_item_hover_styles );
	}
	
	add_action( 'synergia_select_style_dynamic', 'synergia_select_sticky_header_styles' );
}