<?php

if ( ! function_exists( 'synergia_select_header_top_bar_styles' ) ) {
	/**
	 * Generates styles for header top bar
	 */
	function synergia_select_header_top_bar_styles() {
		$top_header_height = synergia_select_options()->getOptionValue( 'top_bar_height' );
		
		if ( ! empty( $top_header_height ) ) {
			echo synergia_select_dynamic_css( '.qodef-top-bar', array( 'height' => synergia_select_filter_px( $top_header_height ) . 'px' ) );
			echo synergia_select_dynamic_css( '.qodef-top-bar .qodef-logo-wrapper a', array( 'max-height' => synergia_select_filter_px( $top_header_height ) . 'px' ) );
		}
		
		echo synergia_select_dynamic_css( '.qodef-top-bar-background', array( 'height' => synergia_select_get_top_bar_background_height() . 'px' ) );
		
		if ( synergia_select_options()->getOptionValue( 'top_bar_in_grid' ) == 'yes' ) {
			$top_bar_grid_selector                = '.qodef-top-bar .qodef-grid .qodef-vertical-align-containers';
			$top_bar_grid_styles                  = array();
			$top_bar_grid_background_color        = synergia_select_options()->getOptionValue( 'top_bar_grid_background_color' );
			$top_bar_grid_background_transparency = synergia_select_options()->getOptionValue( 'top_bar_grid_background_transparency' );
			
			if ( !empty($top_bar_grid_background_color) ) {
				$grid_background_color        = $top_bar_grid_background_color;
				$grid_background_transparency = 1;
				
				if ( $top_bar_grid_background_transparency !== '' ) {
					$grid_background_transparency = $top_bar_grid_background_transparency;
				}
				
				$grid_background_color                   = synergia_select_rgba_color( $grid_background_color, $grid_background_transparency );
				$top_bar_grid_styles['background-color'] = $grid_background_color;
			}
			
			echo synergia_select_dynamic_css( $top_bar_grid_selector, $top_bar_grid_styles );
		}
		
		$top_bar_styles   = array();
		$background_color = synergia_select_options()->getOptionValue( 'top_bar_background_color' );
		$border_color     = synergia_select_options()->getOptionValue( 'top_bar_border_color' );
		
		if ( $background_color !== '' ) {
			$background_transparency = 1;
			if ( synergia_select_options()->getOptionValue( 'top_bar_background_transparency' ) !== '' ) {
				$background_transparency = synergia_select_options()->getOptionValue( 'top_bar_background_transparency' );
			}
			
			$background_color                   = synergia_select_rgba_color( $background_color, $background_transparency );
			$top_bar_styles['background-color'] = $background_color;
			
			echo synergia_select_dynamic_css( '.qodef-top-bar-background', array( 'background-color' => $background_color ) );
		}
		
		if ( synergia_select_options()->getOptionValue( 'top_bar_border' ) == 'yes' && $border_color != '' ) {
			$top_bar_styles['border-bottom'] = '1px solid ' . $border_color;
		}
		
		echo synergia_select_dynamic_css( '.qodef-top-bar', $top_bar_styles );
	}
	
	add_action( 'synergia_select_style_dynamic', 'synergia_select_header_top_bar_styles' );
}