<?php

if ( ! function_exists( 'synergia_select_map_sidebar_meta' ) ) {
	function synergia_select_map_sidebar_meta() {
		$qodef_sidebar_meta_box = synergia_select_create_meta_box(
			array(
				'scope' => apply_filters( 'synergia_select_set_scope_for_meta_boxes', array( 'page' ), 'sidebar_meta' ),
				'title' => esc_html__( 'Sidebar', 'synergia' ),
				'name'  => 'sidebar_meta'
			)
		);
		
		synergia_select_create_meta_box_field(
			array(
				'name'        => 'qodef_sidebar_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Sidebar Layout', 'synergia' ),
				'description' => esc_html__( 'Choose the sidebar layout', 'synergia' ),
				'parent'      => $qodef_sidebar_meta_box,
                'options'       => synergia_select_get_custom_sidebars_options( true )
			)
		);
		
		$qodef_custom_sidebars = synergia_select_get_custom_sidebars();
		if ( count( $qodef_custom_sidebars ) > 0 ) {
			synergia_select_create_meta_box_field(
				array(
					'name'        => 'qodef_custom_sidebar_area_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Widget Area in Sidebar', 'synergia' ),
					'description' => esc_html__( 'Choose Custom Widget area to display in Sidebar"', 'synergia' ),
					'parent'      => $qodef_sidebar_meta_box,
					'options'     => $qodef_custom_sidebars,
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
	}
	
	add_action( 'synergia_select_meta_boxes_map', 'synergia_select_map_sidebar_meta', 31 );
}