<?php

if ( ! function_exists( 'synergia_select_get_title_types_meta_boxes' ) ) {
	function synergia_select_get_title_types_meta_boxes() {
		$title_type_options = apply_filters( 'synergia_select_title_type_meta_boxes', $title_type_options = array( '' => esc_html__( 'Default', 'synergia' ) ) );
		
		return $title_type_options;
	}
}

foreach ( glob( SELECT_FRAMEWORK_MODULES_ROOT_DIR . '/title/types/*/admin/meta-boxes/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'synergia_select_map_title_meta' ) ) {
	function synergia_select_map_title_meta() {
		$title_type_meta_boxes = synergia_select_get_title_types_meta_boxes();
		
		$title_meta_box = synergia_select_create_meta_box(
			array(
				'scope' => apply_filters( 'synergia_select_set_scope_for_meta_boxes', array( 'page', 'post' ), 'title_meta' ),
				'title' => esc_html__( 'Title', 'synergia' ),
				'name'  => 'title_meta'
			)
		);
		
		synergia_select_create_meta_box_field(
			array(
				'name'          => 'qodef_show_title_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'synergia' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'synergia' ),
				'parent'        => $title_meta_box,
				'options'       => synergia_select_get_yes_no_select_array(),
				'args'          => array(
					'dependence' => true,
					'hide'       => array(
						''    => '',
						'no'  => '#qodef_qodef_show_title_area_meta_container',
						'yes' => ''
					),
					'show'       => array(
						''    => '#qodef_qodef_show_title_area_meta_container',
						'no'  => '',
						'yes' => '#qodef_qodef_show_title_area_meta_container'
					)
				)
			)
		);
		
			$show_title_area_meta_container = synergia_select_add_admin_container(
				array(
					'parent'          => $title_meta_box,
					'name'            => 'qodef_show_title_area_meta_container',
					'hidden_property' => 'qodef_show_title_area_meta',
					'hidden_value'    => 'no'
				)
			);
		
				synergia_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_type_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area Type', 'synergia' ),
						'description'   => esc_html__( 'Choose title type', 'synergia' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => $title_type_meta_boxes
					)
				);
		
				synergia_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_in_grid_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area In Grid', 'synergia' ),
						'description'   => esc_html__( 'Set title area content to be in grid', 'synergia' ),
						'options'       => synergia_select_get_yes_no_select_array(),
						'parent'        => $show_title_area_meta_container
					)
				);
		
				synergia_select_create_meta_box_field(
					array(
						'name'        => 'qodef_title_area_height_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Height', 'synergia' ),
						'description' => esc_html__( 'Set a height for Title Area', 'synergia' ),
						'parent'      => $show_title_area_meta_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px'
						)
					)
				);
				
				synergia_select_create_meta_box_field(
					array(
						'name'        => 'qodef_title_area_background_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Background Color', 'synergia' ),
						'description' => esc_html__( 'Choose a background color for title area', 'synergia' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				synergia_select_create_meta_box_field(
					array(
						'name'        => 'qodef_title_area_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'synergia' ),
						'description' => esc_html__( 'Choose an Image for title area', 'synergia' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				synergia_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_background_image_behavior_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Behavior', 'synergia' ),
						'description'   => esc_html__( 'Choose title area background image behavior', 'synergia' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''                    => esc_html__( 'Default', 'synergia' ),
							'hide'                => esc_html__( 'Hide Image', 'synergia' ),
							'responsive'          => esc_html__( 'Enable Responsive Image', 'synergia' ),
							'responsive-disabled' => esc_html__( 'Disable Responsive Image', 'synergia' ),
							'parallax'            => esc_html__( 'Enable Parallax Image', 'synergia' ),
							'parallax-zoom-out'   => esc_html__( 'Enable Parallax With Zoom Out Image', 'synergia' ),
							'parallax-disabled'   => esc_html__( 'Disable Parallax Image', 'synergia' )
						)
					)
				);
				
				synergia_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_vertical_alignment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Vertical Alignment', 'synergia' ),
						'description'   => esc_html__( 'Specify title area content vertical alignment', 'synergia' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''              => esc_html__( 'Default', 'synergia' ),
							'header_bottom' => esc_html__( 'From Bottom of Header', 'synergia' ),
							'window_top'    => esc_html__( 'From Window Top', 'synergia' )
						)
					)
				);
				
				synergia_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_title_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Tag', 'synergia' ),
						'options'       => synergia_select_get_title_tag( true ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				synergia_select_create_meta_box_field(
					array(
						'name'        => 'qodef_title_text_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Title Color', 'synergia' ),
						'description' => esc_html__( 'Choose a color for title text', 'synergia' ),
						'parent'      => $show_title_area_meta_container
					)
				);
				
				synergia_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_subtitle_meta',
						'type'          => 'text',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Text', 'synergia' ),
						'description'   => esc_html__( 'Enter your subtitle text', 'synergia' ),
						'parent'        => $show_title_area_meta_container,
						'args'          => array(
							'col_width' => 6
						)
					)
				);
		
				synergia_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_subtitle_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Tag', 'synergia' ),
						'options'       => synergia_select_get_title_tag( true, array( 'p' => 'p' ) ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				synergia_select_create_meta_box_field(
					array(
						'name'        => 'qodef_subtitle_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Subtitle Color', 'synergia' ),
						'description' => esc_html__( 'Choose a color for subtitle text', 'synergia' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
		/***************** Additional Title Area Layout - start *****************/
		
		do_action( 'synergia_select_additional_title_area_meta_boxes', $show_title_area_meta_container );
		
		/***************** Additional Title Area Layout - end *****************/
		
	}
	
	add_action( 'synergia_select_meta_boxes_map', 'synergia_select_map_title_meta', 60 );
}