<?php

if(!function_exists('synergia_select_map_woocommerce_meta')) {
    function synergia_select_map_woocommerce_meta() {
        $woocommerce_meta_box = synergia_select_create_meta_box(
            array(
                'scope' => array('product'),
                'title' => esc_html__('Product Meta', 'synergia'),
                'name' => 'woo_product_meta'
            )
        );

        synergia_select_create_meta_box_field(array(
            'name'        => 'qodef_product_featured_image_size',
            'type'        => 'select',
            'label'       => esc_html__('Dimensions for Product List Shortcode', 'synergia'),
            'description' => esc_html__('Choose image layout when it appears in Qode Product List - Masonry layout shortcode', 'synergia'),
            'parent'      => $woocommerce_meta_box,
            'options'     => array(
                'qodef-woo-image-normal-width' => esc_html__('Default', 'synergia'),
                'qodef-woo-image-large-width'  => esc_html__('Large Width', 'synergia')
            )
        ));

        synergia_select_create_meta_box_field(
            array(
                'name'          => 'qodef_show_title_area_woo_meta',
                'type'          => 'select',
                'default_value' => '',
                'label'         => esc_html__('Show Title Area', 'synergia'),
                'description'   => esc_html__('Disabling this option will turn off page title area', 'synergia'),
                'parent'        => $woocommerce_meta_box,
                'options'       => synergia_select_get_yes_no_select_array()
            )
        );

        synergia_select_create_meta_box_field(array(
            'name'        => 'qodef_single_product_new_meta',
            'type'        => 'select',
            'label'       => esc_html__('Enable New Product Mark', 'synergia'),
            'description' => esc_html__('Enabling this option will show new product mark on your product lists and product single', 'synergia'),
            'parent'      => $woocommerce_meta_box,
            'options'     => array(
                'no'  => esc_html__('No', 'synergia'),
                'yes' => esc_html__('Yes', 'synergia')
            )
        ));
    }
	
    add_action('synergia_select_meta_boxes_map', 'synergia_select_map_woocommerce_meta', 99);
}