<?php

if ( ! function_exists( 'synergia_select_woocommerce_options_map' ) ) {
	
	/**
	 * Add Woocommerce options page
	 */
	function synergia_select_woocommerce_options_map() {
		
		synergia_select_add_admin_page(
			array(
				'slug'  => '_woocommerce_page',
				'title' => esc_html__( 'Woocommerce', 'synergia' ),
				'icon'  => 'fa fa-shopping-cart'
			)
		);
		
		/**
		 * Product List Settings
		 */
		$panel_product_list = synergia_select_add_admin_panel(
			array(
				'page'  => '_woocommerce_page',
				'name'  => 'panel_product_list',
				'title' => esc_html__( 'Product List', 'synergia' )
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'qodef_woo_product_list_columns',
				'label'         => esc_html__( 'Product List Columns', 'synergia' ),
				'default_value' => 'qodef-woocommerce-columns-4',
				'description'   => esc_html__( 'Choose number of columns for product listing and related products on single product', 'synergia' ),
				'options'       => array(
					'qodef-woocommerce-columns-3' => esc_html__( '3 Columns', 'synergia' ),
					'qodef-woocommerce-columns-4' => esc_html__( '4 Columns', 'synergia' )
				),
				'parent'        => $panel_product_list,
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'qodef_woo_product_list_columns_space',
				'label'         => esc_html__( 'Space Between Items', 'synergia' ),
				'description'   => esc_html__( 'Select space between items for product listing and related products on single product', 'synergia' ),
				'default_value' => 'normal',
				'options'       => synergia_select_get_space_between_items_array(),
				'parent'        => $panel_product_list,
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'text',
				'name'          => 'qodef_woo_products_per_page',
				'label'         => esc_html__( 'Number of products per page', 'synergia' ),
				'description'   => esc_html__( 'Set number of products on shop page', 'synergia' ),
				'parent'        => $panel_product_list,
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'qodef_products_list_title_tag',
				'label'         => esc_html__( 'Products Title Tag', 'synergia' ),
				'default_value' => 'h4',
				'options'       => synergia_select_get_title_tag(),
				'parent'        => $panel_product_list,
			)
		);
		
		/**
		 * Single Product Settings
		 */
		$panel_single_product = synergia_select_add_admin_panel(
			array(
				'page'  => '_woocommerce_page',
				'name'  => 'panel_single_product',
				'title' => esc_html__( 'Single Product', 'synergia' )
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'show_title_area_woo',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will show title area on single post pages', 'synergia' ),
				'parent'        => $panel_single_product,
				'options'       => synergia_select_get_yes_no_select_array(),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'qodef_single_product_title_tag',
				'default_value' => 'h2',
				'label'         => esc_html__( 'Single Product Title Tag', 'synergia' ),
				'options'       => synergia_select_get_title_tag(),
				'parent'        => $panel_single_product,
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_number_of_thumb_images',
				'default_value' => '4',
				'label'         => esc_html__( 'Number of Thumbnail Images per Row', 'synergia' ),
				'options'       => array(
					'4' => esc_html__( 'Four', 'synergia' ),
					'3' => esc_html__( 'Three', 'synergia' ),
					'2' => esc_html__( 'Two', 'synergia' )
				),
				'parent'        => $panel_single_product
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_set_thumb_images_position',
				'default_value' => 'below-image',
				'label'         => esc_html__( 'Set Thumbnail Images Position', 'synergia' ),
				'options'       => array(
					'below-image'  => esc_html__( 'Below Featured Image', 'synergia' ),
					'on-left-side' => esc_html__( 'On The Left Side Of Featured Image', 'synergia' )
				),
				'parent'        => $panel_single_product
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_enable_single_product_zoom_image',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Zoom Maginfier', 'synergia' ),
				'description'   => esc_html__( 'Enabling this option will show magnifier image on featured image hover', 'synergia' ),
				'parent'        => $panel_single_product,
				'options'       => synergia_select_get_yes_no_select_array( false ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		synergia_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_set_single_images_behavior',
				'default_value' => 'pretty-photo',
				'label'         => esc_html__( 'Set Images Behavior', 'synergia' ),
				'options'       => array(
					'pretty-photo' => esc_html__( 'Pretty Photo Lightbox', 'synergia' ),
					'photo-swipe'  => esc_html__( 'Photo Swipe Lightbox', 'synergia' )
				),
				'parent'        => $panel_single_product
			)
		);
	}
	
	add_action( 'synergia_select_options_map', 'synergia_select_woocommerce_options_map', 21 );
}