<div class="qodef-product-holder">

    <div class="qodef-product-category">
        <span class="qodef-product-category-line qodef-gradient-vertical"></span>
        <?php foreach ($categories as $cat) { ?>
            <a itemprop="url" class="qodef-pi-category-item qodef-gradient-vertical-text"
               href="<?php echo esc_url(get_term_link($cat->term_id)); ?>"><?php echo esc_html($cat->name); ?></a>
        <?php } ?>
    </div>

    <h3 itemprop="name" class="qodef-product-title entry-title">
        <a itemprop="url"
           href="<?php echo esc_url(get_the_permalink($product_id)); ?>"><?php echo esc_html(get_the_title($product_id)); ?></a>
    </h3>

    <div class="qodef-product-price">
        <?php print synergia_select_get_module_part($product->get_price_html()); ?>
    </div>

    <?php if (!empty($excerpt)) { ?>

        <div class="qodef-product-excerpt">
            <p itemprop="description" class="qodef-product-excerpt-item">
                <?php echo esc_html($excerpt); ?>
            </p>
        </div>

    <?php } ?>

    <div class="qodef-product-add-to-cart">
        <?php
        echo apply_filters('synergia_select_product_info_add_to_cart_link',
            sprintf('<a rel="nofollow" href="%s" data-quantity="%s" data-product_id="%s" data-product_sku="%s" class="%s">%s</a>',
                esc_url($product->add_to_cart_url()),
                esc_attr(isset($quantity) ? $quantity : 1),
                esc_attr($product_id),
                esc_attr($product->get_sku()),
                esc_attr($button_classes),
                esc_html($button_text)
            ),
            $product); ?>
    </div>
</div>