<div class="qodef-testimonial-content" id="qodef-testimonials-<?php echo esc_attr($current_id) ?>">
    <div class="qodef-testimonial-content-inner">
        <?php if (!empty($categories)) { ?>
            <h6 class="qodef-label">
                <span class="qodef-label-line"></span>
            <span class="qodef-label-text">
                <?php print esc_html($categories); ?>
            </span>
            </h6>
        <?php } ?>
        <div class="qodef-testimonial-text-holder">
            <?php if (!empty($title)) { ?>
                <h3 itemprop="name" class="qodef-testimonial-title entry-title"><?php echo esc_html($title); ?></h3>
            <?php } ?>
            <?php if (!empty($text)) { ?>
                <p class="qodef-testimonial-text"><?php echo esc_html($text); ?></p>
            <?php } ?>
        </div>
    </div>
    <div class="qodef-testimonial-image-author-position">
        <?php if (has_post_thumbnail()) { ?>
            <div class="qodef-testimonial-image">
                <?php echo get_the_post_thumbnail(get_the_ID(), array(55, 55)); ?>
            </div>
        <?php }
        if (!empty($author) || !empty($position)) { ?>
            <div class="qodef-testimonial-author-position">
                <?php if (!empty($author)) { ?>
                    <h6 class="qodef-testimonial-author">
                        <?php echo esc_html($author); ?>
                    </h6>
                <?php }
                if (!empty($company)) { ?>
                    <h6 class="qodef-testimonial-company qodef-gradient-vertical-text">
                        @<?php echo esc_html($company); ?>
                    </h6>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
</div>