<?php
namespace QodeCore\CPT\Shortcodes\ItemShowcase;

use QodeCore\Lib;

class ItemShowcaseItem implements Lib\ShortcodeInterface {
	private $base;
	
	function __construct() {
		$this->base = 'qodef_item_showcase_item';
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                    => esc_html__( 'Select Item Showcase List Item', 'select-core' ),
					'base'                    => $this->base,
					'as_child'                => array( 'only' => 'qodef_item_showcase' ),
					'as_parent'               => array( 'except' => 'vc_row' ),
					'content_element'         => true,
					'category'                => esc_html__( 'by Select', 'select-core' ),
					'icon'                    => 'icon-wpb-item-showcase-item extended-custom-icon',
					'show_settings_on_create' => true,
					'params'                  => array_merge(array(
						array(
							'type'        => 'dropdown',
							'param_name'  => 'item_position',
							'heading'     => esc_html__( 'Item Position', 'select-core' ),
							'value'       => array(
								esc_html__( 'Left', 'select-core' )  => 'left',
								esc_html__( 'Right', 'select-core' ) => 'right'
							),
							'save_always' => true,
							'admin_label' => true
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'item_title',
							'heading'     => esc_html__( 'Item Title', 'select-core' ),
							'admin_label' => true
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'item_link',
							'heading'    => esc_html__( 'Item Link', 'select-core' ),
							'dependency' => array( 'element' => 'item_title', 'not_empty' => true )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'item_target',
							'heading'     => esc_html__( 'Item Target', 'select-core' ),
							'value'       => array_flip( synergia_select_get_link_target_array() ),
							'dependency'  => array( 'element' => 'item_link', 'not_empty' => true ),
							'save_always' => true
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'item_title_tag',
							'heading'     => esc_html__( 'Item Title Tag', 'select-core' ),
							'value'       => array_flip( synergia_select_get_title_tag( true ) ),
							'save_always' => true,
							'dependency'  => array( 'element' => 'item_title', 'not_empty' => true )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'item_title_color',
							'heading'    => esc_html__( 'Item Title Color', 'select-core' ),
							'dependency' => array( 'element' => 'item_title', 'not_empty' => true )
						),
						array(
							'type'       => 'textarea',
							'param_name' => 'item_text',
							'heading'    => esc_html__( 'Item Text', 'select-core' )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'item_text_color',
							'heading'    => esc_html__( 'Item Text Color', 'select-core' ),
							'dependency' => array( 'element' => 'item_text', 'not_empty' => true )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'item_text_offset',
							'heading'     => esc_html__( 'Item Text Top Offset', 'select-core' ),
							'value'       => '0',
							'save_always' => true
						)),
						synergia_select_icon_collections()->getVCParamsArray(),
						array(
							array(
								'type'       => 'attach_image',
								'param_name' => 'custom_icon',
								'heading'    => esc_html__('Custom Icon', 'select-core')
							),
							array(
								'type'       => 'dropdown',
								'param_name' => 'icon_type',
								'heading'    => esc_html__('Icon Type', 'select-core'),
								'value'      => array(
									esc_html__('Normal', 'select-core')          => 'qodef-normal',
									esc_html__('Circle', 'select-core')          => 'qodef-circle',
									esc_html__('Square', 'select-core')          => 'qodef-square',
									esc_html__('Gradient', 'select-core')        => 'qodef-gradient-vertical-text',
									esc_html__('Gradient Circle', 'select-core') => 'qodef-gradient-vertical'
								),
								'group'      => esc_html__('Icon Settings', 'select-core')
							),
							array(
								'type'       => 'dropdown',
								'param_name' => 'icon_size',
								'heading'    => esc_html__('Icon Size', 'select-core'),
								'value'      => array(
									esc_html__('Medium', 'select-core')     => 'qodef-icon-medium',
									esc_html__('Tiny', 'select-core')       => 'qodef-icon-tiny',
									esc_html__('Small', 'select-core')      => 'qodef-icon-small',
									esc_html__('Large', 'select-core')      => 'qodef-icon-large',
									esc_html__('Very Large', 'select-core') => 'qodef-icon-huge'
								),
								'group'      => esc_html__('Icon Settings', 'select-core')
							),
							array(
								'type'       => 'textfield',
								'param_name' => 'custom_icon_size',
								'heading'    => esc_html__('Custom Icon Size (px)', 'select-core'),
								'group'      => esc_html__('Icon Settings', 'select-core')
							),
							array(
								'type'       => 'textfield',
								'param_name' => 'shape_size',
								'heading'    => esc_html__('Shape Size (px)', 'select-core'),
								'group'      => esc_html__('Icon Settings', 'select-core')
							),
							array(
								'type'       => 'colorpicker',
								'param_name' => 'icon_color',
								'heading'    => esc_html__('Icon Color', 'select-core'),
								'group'      => esc_html__('Icon Settings', 'select-core')
							),
							array(
								'type'       => 'colorpicker',
								'param_name' => 'icon_hover_color',
								'heading'    => esc_html__('Icon Hover Color', 'select-core'),
								'group'      => esc_html__('Icon Settings', 'select-core')
							),
							array(
								'type'       => 'colorpicker',
								'param_name' => 'icon_background_color',
								'heading'    => esc_html__('Icon Background Color', 'select-core'),
								'dependency' => array(
									'element' => 'icon_type',
									'value'   => array('qodef-square', 'qodef-circle', 'qodef-gradient-vertical')
								),
								'group'      => esc_html__('Icon Settings', 'select-core')
							),
							array(
								'type'       => 'colorpicker',
								'param_name' => 'icon_hover_background_color',
								'heading'    => esc_html__('Icon Hover Background Color', 'select-core'),
								'dependency' => array(
									'element' => 'icon_type',
									'value'   => array('qodef-square', 'qodef-circle', 'qodef-gradient-vertical')
								),
								'group'      => esc_html__('Icon Settings', 'select-core')
							),
							array(
								'type'       => 'colorpicker',
								'param_name' => 'icon_border_color',
								'heading'    => esc_html__('Icon Border Color', 'select-core'),
								'dependency' => array(
									'element' => 'icon_type',
									'value'   => array('qodef-square', 'qodef-circle')
								),
								'group'      => esc_html__('Icon Settings', 'select-core')
							),
							array(
								'type'       => 'colorpicker',
								'param_name' => 'icon_border_hover_color',
								'heading'    => esc_html__('Icon Border Hover Color', 'select-core'),
								'dependency' => array(
									'element' => 'icon_type',
									'value'   => array('qodef-square', 'qodef-circle')
								),
								'group'      => esc_html__('Icon Settings', 'select-core')
							),
							array(
								'type'       => 'textfield',
								'param_name' => 'icon_border_width',
								'heading'    => esc_html__('Border Width (px)', 'select-core'),
								'dependency' => array(
									'element' => 'icon_type',
									'value'   => array('qodef-square', 'qodef-circle')
								),
								'group'      => esc_html__('Icon Settings', 'select-core')
							),
							array(
								'type'       => 'dropdown',
								'param_name' => 'icon_animation',
								'heading'    => esc_html__('Icon Animation', 'select-core'),
								'value'      => array_flip(synergia_select_get_yes_no_select_array(false)),
								'group'      => esc_html__('Icon Settings', 'select-core')
							),
							array(
								'type'       => 'textfield',
								'param_name' => 'icon_animation_delay',
								'heading'    => esc_html__('Icon Animation Delay (ms)', 'select-core'),
								'dependency' => array('element' => 'icon_animation', 'value' => array('yes')),
								'group'      => esc_html__('Icon Settings', 'select-core')
							)
						)
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'item_position'    => 'left',
			'item_title'       => '',
			'item_link'        => '',
			'item_target'      => '_self',
			'item_title_tag'   => 'h5',
			'item_title_color' => '',
			'item_text'        => '',
			'item_text_color'  => '',
			'item_text_offset' => '',
			'custom_icon'                 => '',
			'icon_type'                   => 'qodef-normal',
			'icon_size'                   => 'qodef-icon-medium',
			'custom_icon_size'            => '',
			'shape_size'                  => '',
			'icon_color'                  => '',
			'icon_hover_color'            => '',
			'icon_background_color'       => '',
			'icon_hover_background_color' => '',
			'icon_border_color'           => '',
			'icon_border_hover_color'     => '',
			'icon_border_width'           => '',
			'icon_animation'              => '',
			'icon_animation_delay'        => '',
		);
		$default_atts = array_merge($args, synergia_select_icon_collections()->getShortcodeParams());
		$params = shortcode_atts( $default_atts, $atts );


		$params['item_text_holder_styles']    = $this->getTextStyles( $params );
		if ( ! empty( $params['item_text_offset'] ) ) {
			$params['item_text_holder_styles'] = 'margin-top: ' . synergia_select_filter_px( $params['item_text_offset'] ) . 'px';
		}

		$params['icon_parameters'] = $this->getIconParameters($params);
		$params['showcase_item_class'] = $this->getShowcaseItemClasses( $params );
		$params['item_target']         = ! empty( $params['item_target'] ) ? $params['item_target'] : $args['item_target'];
		$params['item_title_tag']      = ! empty( $params['item_title_tag'] ) ? $params['item_title_tag'] : $args['item_title_tag'];
		$params['item_title_styles']   = $this->getTitleStyles( $params );
		$params['item_text_styles']    = $this->getTextStyles( $params );
		
		$html = qodef_core_get_shortcode_module_template_part( 'templates/item-showcase-item', 'item-showcase', '', $params );
		
		return $html;
	}
	
	private function getShowcaseItemClasses( $params ) {
		$itemClass = array();
		
		if ( ! empty( $params['item_position'] ) ) {
			$itemClass[] = 'qodef-is-' . $params['item_position'];
		}
		
		return implode( ' ', $itemClass );
	}
	
	private function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['item_title_color'] ) ) {
			$styles[] = 'color: ' . $params['item_title_color'];
		}
		
		return implode( ';', $styles );
	}
	
	private function getTextStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['item_text_color'] ) ) {
			$styles[] = 'color: ' . $params['item_text_color'];
		}
		
		return implode( ';', $styles );
	}

	private function getIconParameters($params) {
		$params_array = array();

		if (empty($params['custom_icon'])) {
			$iconPackName = synergia_select_icon_collections()->getIconCollectionParamNameByKey($params['icon_pack']);

			$params_array['icon_pack'] = $params['icon_pack'];
			$params_array[$iconPackName] = $params[$iconPackName];

			if (!empty($params['icon_size'])) {
				$params_array['size'] = $params['icon_size'];
			}

			if (!empty($params['custom_icon_size'])) {
				$params_array['custom_size'] = synergia_select_filter_px($params['custom_icon_size']) . 'px';
			}

			if (!empty($params['icon_type'])) {
				$params_array['type'] = $params['icon_type'];
			}

			if (!empty($params['shape_size'])) {
				$params_array['shape_size'] = synergia_select_filter_px($params['shape_size']) . 'px';
			}

			if (!empty($params['icon_border_color'])) {
				$params_array['border_color'] = $params['icon_border_color'];
			}

			if (!empty($params['icon_border_hover_color'])) {
				$params_array['hover_border_color'] = $params['icon_border_hover_color'];
			}

			if ($params['icon_border_width'] !== '') {
				$params_array['border_width'] = synergia_select_filter_px($params['icon_border_width']) . 'px';
			}

			if (!empty($params['icon_background_color'])) {
				$params_array['background_color'] = $params['icon_background_color'];
			}

			if (!empty($params['icon_hover_background_color'])) {
				$params_array['hover_background_color'] = $params['icon_hover_background_color'];
			}

			$params_array['icon_color'] = $params['icon_color'];

			if (!empty($params['icon_hover_color'])) {
				$params_array['hover_icon_color'] = $params['icon_hover_color'];
			}

			$params_array['icon_animation'] = $params['icon_animation'];
			$params_array['icon_animation_delay'] = $params['icon_animation_delay'];
		}

		return $params_array;
	}
}
