<?php

class SynergiaSelectButtonWidget extends SynergiaSelectWidget {
	public function __construct() {
		parent::__construct(
			'qodef_button_widget',
			esc_html__( 'Select Button Widget', 'synergia-core' ),
			array( 'description' => esc_html__( 'Add button element to widget areas', 'synergia-core' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'    => 'dropdown',
				'name'    => 'type',
				'title'   => esc_html__( 'Type', 'synergia-core' ),
				'options' => array(
					'solid'   => esc_html__( 'Solid', 'synergia-core' ),
					'outline' => esc_html__( 'Outline', 'synergia-core' ),
					'simple'  => esc_html__( 'Simple', 'synergia-core' )
				)
			),
			array(
				'type'        => 'dropdown',
				'name'        => 'size',
				'title'       => esc_html__( 'Size', 'synergia-core' ),
				'options'     => array(
					'small'  => esc_html__( 'Small', 'synergia-core' ),
					'medium' => esc_html__( 'Medium', 'synergia-core' ),
					'large'  => esc_html__( 'Large', 'synergia-core' ),
					'huge'   => esc_html__( 'Huge', 'synergia-core' )
				),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'synergia-core' )
			),
			array(
				'type'    => 'textfield',
				'name'    => 'text',
				'title'   => esc_html__( 'Text', 'synergia-core' ),
				'default' => esc_html__( 'Button Text', 'synergia-core' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'link',
				'title' => esc_html__( 'Link', 'synergia-core' )
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'target',
				'title'   => esc_html__( 'Link Target', 'synergia-core' ),
				'options' => synergia_select_get_link_target_array()
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'color',
				'title' => esc_html__( 'Color', 'synergia-core' )
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'hover_color',
				'title' => esc_html__( 'Hover Color', 'synergia-core' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'background_color',
				'title'       => esc_html__( 'Background Color', 'synergia-core' ),
				'description' => esc_html__( 'This option is only available for solid button type', 'synergia-core' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'hover_background_color',
				'title'       => esc_html__( 'Hover Background Color', 'synergia-core' ),
				'description' => esc_html__( 'This option is only available for solid button type', 'synergia-core' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'border_color',
				'title'       => esc_html__( 'Border Color', 'synergia-core' ),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'synergia-core' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'hover_border_color',
				'title'       => esc_html__( 'Hover Border Color', 'synergia-core' ),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'synergia-core' )
			),
			array(
				'type'        => 'textfield',
				'name'        => 'margin',
				'title'       => esc_html__( 'Margin', 'synergia-core' ),
				'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'synergia-core' )
			)
		);
	}
	
	public function widget( $args, $instance ) {
		$params = '';
		
		if ( ! is_array( $instance ) ) {
			$instance = array();
		}
		
		// Filter out all empty params
		$instance = array_filter( $instance, function ( $array_value ) {
			return trim( $array_value ) != '';
		} );
		
		// Default values
		if ( ! isset( $instance['text'] ) ) {
			$instance['text'] = 'Button Text';
		}
		
		// Generate shortcode params
		foreach ( $instance as $key => $value ) {
			$params .= " $key='$value' ";
		}
		
		echo '<div class="widget qodef-button-widget">';
			echo do_shortcode( "[qodef_button $params]" ); // XSS OK
		echo '</div>';
	}
}