<?php

class SynergiaSelectIconWidget extends SynergiaSelectWidget
{
    public function __construct() {
        parent::__construct(
            'qodef_icon_widget',
            esc_html__('Select Icon Widget', 'synergia-core'),
            array('description' => esc_html__('Add icons to widget areas', 'synergia-core'))
        );

        $this->setParams();
    }

    protected function setParams() {
        $this->params = array_merge(
            synergia_select_icon_collections()->getIconWidgetParamsArray(),
            array(
                array(
                    'type'  => 'textfield',
                    'name'  => 'icon_text',
                    'title' => esc_html__('Icon Text', 'synergia-core')
                ),
                array(
                    'type'  => 'textfield',
                    'name'  => 'link',
                    'title' => esc_html__('Link', 'synergia-core')
                ),
                array(
                    'type'    => 'dropdown',
                    'name'    => 'target',
                    'title'   => esc_html__('Target', 'synergia-core'),
                    'options' => synergia_select_get_link_target_array()
                ),
                array(
                    'type'  => 'textfield',
                    'name'  => 'icon_size',
                    'title' => esc_html__('Icon Size (px)', 'synergia-core')
                ),
                array(
                    'type'  => 'colorpicker',
                    'name'  => 'icon_color',
                    'title' => esc_html__('Icon Color', 'synergia-core')
                ),
                array(
                    'type'  => 'colorpicker',
                    'name'  => 'icon_hover_color',
                    'title' => esc_html__('Icon Hover Color', 'synergia-core')
                ),
                array(
                    'type'        => 'textfield',
                    'name'        => 'icon_margin',
                    'title'       => esc_html__('Icon Margin', 'synergia-core'),
                    'description' => esc_html__('Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'synergia-core')
                ),
            )
        );
    }

    public function widget($args, $instance) {
        $holder_classes = array('qodef-icon-widget-holder');

        $data = array();
        $data[] = !empty($instance['icon_hover_color']) ? synergia_select_get_inline_attr($instance['icon_hover_color'], 'data-hover-color') : '';
        $data = implode(' ', $data);

        $styles = array();
        if ($instance['icon_margin'] !== '') {
            $styles[] = 'margin: ' . $instance['icon_margin'];
        }

        if (!empty($instance['icon_color'])) {
            $styles[] = 'color: ' . $instance['icon_color'];
        }

        if (!empty($instance['icon_size'])) {
            $styles[] = 'font-size: ' . synergia_select_filter_px($instance['icon_size']) . 'px';
        }

        $link = $instance['link'];
        $target = !empty($instance['target']) ? $instance['target'] : '_self';

        $icon_holder_html = '';
        if (!empty($instance['icon_pack'])) {
            $icon_class = array();
            $icon_class[] = !empty($instance['fa_icon']) && $instance['icon_pack'] === 'font_awesome' ? 'fa ' . $instance['fa_icon'] : '';
            $icon_class[] = !empty($instance['fe_icon']) && $instance['icon_pack'] === 'font_elegant' ? $instance['fe_icon'] : '';
            $icon_class[] = !empty($instance['ion_icon']) && $instance['icon_pack'] === 'ion_icons' ? $instance['ion_icon'] : '';
            $icon_class[] = !empty($instance['linea_icon']) && $instance['icon_pack'] === 'linea_icons' ? $instance['linea_icon'] : '';
            $icon_class[] = !empty($instance['linear_icon']) && $instance['icon_pack'] === 'linear_icons' ? 'lnr ' . $instance['linear_icon'] : '';
            $icon_class[] = !empty($instance['simple_line_icon']) && $instance['icon_pack'] === 'simple_line_icons' ? $instance['simple_line_icon'] : '';
            $icon_class[] = !empty($instance['dripicon']) && $instance['icon_pack'] === 'dripicons' ? $instance['dripicon'] : '';

            if (!empty($instance['icon_hover_color'])) {
                $icon_class[] = 'qodef-icon-has-hover';
            }

            $icon_class = array_filter($icon_class, function ($value) {
                return $value !== '';
            });

            if (!empty($icon_class)) {
                $icon_class = implode(' ', $icon_class);

                $icon_holder_html = '<span class="qodef-icon-element ' . esc_attr($icon_class) . '" ' . synergia_select_get_inline_style($styles) . ' ' . wp_kses_post($data) . '></span>';
            }
        }

        $icon_text_html = '';
        $icon_text_class = !empty($icon_holder_html) ? '' : 'qodef-no-icon';
        if (!empty($instance['icon_text'])) {
            $icon_text_html = '<span class="qodef-icon-text ' . esc_attr($icon_text_class) . '">' . esc_html($instance['icon_text']) . '</span>';
        }
        ?>

        <span <?php synergia_select_class_attribute($holder_classes); ?>>
        <?php if (!empty($link)) { ?>
            <a href="<?php echo esc_url($link); ?>" target="<?php echo esc_attr($target); ?>">
                <?php }
                echo wp_kses($icon_holder_html, array(
                    'span' => array(
                        'class'            => true,
                        'style'            => true,
                        'data-hover-color' => true
                    )
                ));
                if (!empty($link)) { ?>
            </a>
        <?php }

        echo wp_kses($icon_text_html, array(
            'span' => array(
                'class' => true
            )
        )); ?>
</span> <?php
    }
}