<?php

class SynergiaSelectSeparatorWidget extends SynergiaSelectWidget {
	public function __construct() {
		parent::__construct(
			'qodef_separator_widget',
			esc_html__( 'Select Separator Widget', 'synergia-core' ),
			array( 'description' => esc_html__( 'Add a separator element to your widget areas', 'synergia-core' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'    => 'dropdown',
				'name'    => 'type',
				'title'   => esc_html__( 'Type', 'synergia-core' ),
				'options' => array(
					'normal'     => esc_html__( 'Normal', 'synergia-core' ),
					'full-width' => esc_html__( 'Full Width', 'synergia-core' )
				)
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'position',
				'title'   => esc_html__( 'Position', 'synergia-core' ),
				'options' => array(
					'center' => esc_html__( 'Center', 'synergia-core' ),
					'left'   => esc_html__( 'Left', 'synergia-core' ),
					'right'  => esc_html__( 'Right', 'synergia-core' )
				)
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'border_style',
				'title'   => esc_html__( 'Style', 'synergia-core' ),
				'options' => array(
					'solid'  => esc_html__( 'Solid', 'synergia-core' ),
					'dashed' => esc_html__( 'Dashed', 'synergia-core' ),
					'dotted' => esc_html__( 'Dotted', 'synergia-core' )
				)
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'color',
				'title' => esc_html__( 'Color', 'synergia-core' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'width',
				'title' => esc_html__( 'Width (px or %)', 'synergia-core' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'thickness',
				'title' => esc_html__( 'Thickness (px)', 'synergia-core' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'top_margin',
				'title' => esc_html__( 'Top Margin (px or %)', 'synergia-core' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'bottom_margin',
				'title' => esc_html__( 'Bottom Margin (px or %)', 'synergia-core' )
			)
		);
	}
	
	public function widget( $args, $instance ) {
		if ( ! is_array( $instance ) ) {
			$instance = array();
		}
		
		//prepare variables
		$params = '';
		
		//is instance empty?
		if ( is_array( $instance ) && count( $instance ) ) {
			//generate shortcode params
			foreach ( $instance as $key => $value ) {
				$params .= " $key='$value' ";
			}
		}
		
		echo '<div class="widget qodef-separator-widget">';
			echo do_shortcode( "[qodef_separator $params]" ); // XSS OK
		echo '</div>';
	}
}